/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LightningStrike;

public class Commandlightning
extends EssentialsLoopCommand {
    public Commandlightning() {
        super("lightning");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length == 0 || !sender.isAuthorized("essentials.lightning.others")) {
            if (sender.isPlayer()) {
                sender.getPlayer().getWorld().strikeLightning(sender.getUser().getTargetBlock(600).getLocation());
                return;
            }
            throw new NotEnoughArgumentsException();
        }
        int power = 5;
        if (args.length > 1) {
            try {
                power = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int finalPower = power;
        this.loopOnlinePlayersConsumer(server, sender, false, true, args[0], player -> {
            sender.sendTl("lightningUse", player.getDisplayName());
            LightningStrike strike = player.getBase().getWorld().strikeLightningEffect(player.getBase().getLocation());
            if (!player.isGodModeEnabled()) {
                player.getBase().damage((double)finalPower, (Entity)strike);
            }
            if (this.ess.getSettings().warnOnSmite()) {
                player.sendTl("lightningSmited", new Object[0]);
            }
        });
        this.loopOnlinePlayers(server, sender, true, true, args[0], null);
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User matchUser, String[] args) {
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (!user.isAuthorized("essentials.lightning.others")) {
            return Collections.emptyList();
        }
        return super.getTabCompleteOptions(server, user, commandLabel, args);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        if (args.length == 2) {
            return Lists.newArrayList((Object[])new String[]{"5"});
        }
        return Collections.emptyList();
    }
}

