/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.ess3.api.TranslatableException;
import net.essentialsx.api.v2.events.UserKickEvent;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commandkick
extends EssentialsCommand {
    public Commandkick() {
        super("kick");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        User user;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User target = this.getPlayer(server, args, 0, true, false);
        User user2 = user = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : null;
        if (user != null) {
            if (target.isHidden(sender.getPlayer()) && !user.canInteractVanished() && target.isHiddenFrom(sender.getPlayer())) {
                throw new PlayerNotFoundException();
            }
            if (target.isAuthorized("essentials.kick.exempt")) {
                throw new TranslatableException("kickExempt", new Object[0]);
            }
        }
        String kickReason = args.length > 1 ? Commandkick.getFinalArg(args, 1) : AdventureUtil.miniToLegacy(I18n.tlLiteral("kickDefault", new Object[0]));
        kickReason = FormatUtil.replaceFormat(kickReason.replace("\\n", "\n").replace("|", "\n"));
        UserKickEvent event = new UserKickEvent(user, target, kickReason);
        this.ess.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        kickReason = event.getReason();
        target.getBase().kickPlayer(kickReason);
        String senderDisplayName = sender.isPlayer() ? sender.getPlayer().getDisplayName() : Console.DISPLAY_NAME;
        String tlKey = "playerKicked";
        Object[] objects = new Object[]{senderDisplayName, target.getName(), kickReason};
        this.ess.getLogger().log(Level.INFO, AdventureUtil.miniToLegacy(I18n.tlLiteral("playerKicked", objects)));
        this.ess.broadcastTl(null, "essentials.kick.notify", "playerKicked", objects);
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }
}

