/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.utils.LocationUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.ess3.api.TranslatableException;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerTeleportEvent;

public class Commandjump
extends EssentialsCommand {
    public Commandjump() {
        super("jump");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        Location loc;
        if (args.length > 0 && args[0].contains("lock") && user.isAuthorized("essentials.jump.lock")) {
            if (user.isFlyClickJump()) {
                user.setRightClickJump(false);
                user.sendTl("jumpEasterDisable", new Object[0]);
            } else {
                user.setRightClickJump(true);
                user.sendTl("jumpEasterEnable", new Object[0]);
            }
            return;
        }
        Location cloc = user.getLocation();
        try {
            loc = LocationUtil.getTarget((LivingEntity)user.getBase());
            loc.setYaw(cloc.getYaw());
            loc.setPitch(cloc.getPitch());
            loc.setY(loc.getY() + 1.0);
        }
        catch (NullPointerException ex) {
            throw new TranslatableException(ex, "jumpError", new Object[0]);
        }
        Trade charge = new Trade(this.getName(), this.ess);
        charge.isAffordableFor(user);
        user.getAsyncTeleport().teleport(loc, charge, PlayerTeleportEvent.TeleportCause.COMMAND, this.getNewExceptionFuture(user.getSource(), commandLabel));
        throw new NoChargeException();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        if (args.length == 1 && user.isAuthorized("essentials.jump.lock")) {
            return Lists.newArrayList((Object[])new String[]{"lock", "unlock"});
        }
        return Collections.emptyList();
    }
}

