/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.SetExpFix;
import com.earth2me.essentials.utils.NumberUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.Server;

public class Commandexp
extends EssentialsLoopCommand {
    public Commandexp() {
        super("exp");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        ExpCommands cmd;
        net.ess3.api.IUser user = sender.getUser();
        if (args.length == 0 || args.length < 2 && user == null) {
            if (user == null) {
                throw new NotEnoughArgumentsException();
            }
            this.showExp(sender, user);
            return;
        }
        try {
            cmd = ExpCommands.valueOf(args[0].toUpperCase(Locale.ENGLISH));
        }
        catch (Exception ex) {
            throw new NotEnoughArgumentsException(ex);
        }
        if (!cmd.hasPermission(user)) {
            user.sendTl("noAccessSubCommand", "/" + commandLabel + " " + cmd.name().toLowerCase(Locale.ENGLISH));
            return;
        }
        switch (cmd.ordinal()) {
            case 0: {
                if (args.length == 3 && cmd.hasOtherPermission(user)) {
                    this.loopOnlinePlayersConsumer(server, sender, false, true, args[1], player -> this.setExp(sender, player, args[2], false));
                } else if (args.length == 2 && user != null) {
                    this.setExp(sender, user, args[1], false);
                } else {
                    throw new NotEnoughArgumentsException();
                }
                return;
            }
            case 1: {
                if (args.length == 3 && cmd.hasOtherPermission(user)) {
                    this.loopOnlinePlayersConsumer(server, sender, false, true, args[1], player -> this.setExp(sender, player, args[2], true));
                } else if (args.length == 2 && user != null) {
                    this.setExp(sender, user, args[1], true);
                } else {
                    throw new NotEnoughArgumentsException();
                }
                return;
            }
            case 2: {
                if (args.length == 3 && cmd.hasOtherPermission(user)) {
                    this.loopOnlinePlayersConsumer(server, sender, false, true, args[1], player -> this.setExp(sender, player, "-" + args[2], true));
                } else if (args.length == 2) {
                    this.setExp(sender, user, "-" + args[1], true);
                } else {
                    throw new NotEnoughArgumentsException();
                }
                return;
            }
            case 3: {
                if (args.length == 2 && cmd.hasOtherPermission(user)) {
                    this.loopOnlinePlayersConsumer(server, sender, false, true, args[1], player -> this.setExp(sender, player, "0", false));
                } else if (user != null) {
                    this.setExp(sender, user, "0", false);
                } else {
                    throw new NotEnoughArgumentsException();
                }
                return;
            }
            case 4: {
                if (args.length == 2 && (user == null || user.isAuthorized("essentials.exp.others"))) {
                    this.showExp(sender, this.getPlayer(server, sender, args[1]));
                } else if (user != null) {
                    this.showExp(sender, user);
                } else {
                    throw new NotEnoughArgumentsException();
                }
                return;
            }
        }
        throw new NotEnoughArgumentsException();
    }

    private void showExp(CommandSource sender, IUser target) {
        sender.sendTl("exp", target.getDisplayName(), SetExpFix.getTotalExperience(target.getBase()), target.getBase().getLevel(), SetExpFix.getExpUntilNextLevel(target.getBase()));
    }

    private void setExp(CommandSource sender, IUser target, String strAmount, boolean give) throws NotEnoughArgumentsException {
        long amount;
        if ((strAmount = strAmount.toLowerCase(Locale.ENGLISH)).contains("l")) {
            strAmount = strAmount.replaceAll("l", "");
            int neededLevel = Integer.parseInt(strAmount);
            if (give) {
                neededLevel += target.getBase().getLevel();
            }
            amount = SetExpFix.getExpToLevel(neededLevel);
            SetExpFix.setTotalExperience(target.getBase(), 0);
        } else {
            amount = Long.parseLong(strAmount);
            if (amount > Integer.MAX_VALUE || amount < Integer.MIN_VALUE) {
                throw new NotEnoughArgumentsException();
            }
        }
        if (give) {
            amount += (long)SetExpFix.getTotalExperience(target.getBase());
        }
        if (amount > Integer.MAX_VALUE) {
            amount = Integer.MAX_VALUE;
        }
        if (amount < 0L) {
            amount = 0L;
        }
        SetExpFix.setTotalExperience(target.getBase(), (int)amount);
        sender.sendTl("expSet", target.getDisplayName(), amount);
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User user, String[] args) {
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, User user, String commandLabel, String[] args) {
        String levellessArg;
        if (args.length == 1) {
            ArrayList options = Lists.newArrayList((Object[])new String[]{"show"});
            for (ExpCommands cmd : ExpCommands.values()) {
                if (!cmd.hasPermission(user)) continue;
                options.add(cmd.name().toLowerCase(Locale.ENGLISH));
            }
            return options;
        }
        if (args.length == 2) {
            String levellessArg2;
            if ((args[0].equalsIgnoreCase("set") && user.isAuthorized("essentials.exp.set") || args[0].equalsIgnoreCase("give") && user.isAuthorized("essentials.exp.give") || args[0].equalsIgnoreCase("take") && user.isAuthorized("essentials.exp.take")) && NumberUtil.isInt(levellessArg2 = args[1].toLowerCase(Locale.ENGLISH).replaceAll("l", ""))) {
                return Lists.newArrayList((Object[])new String[]{levellessArg2 + "l"});
            }
            if (user.isAuthorized("essentials.exp.others")) {
                return this.getPlayers(server, user);
            }
        } else if (args.length == 3 && !args[0].equalsIgnoreCase("show") && !args[0].equalsIgnoreCase("reset") && NumberUtil.isInt(levellessArg = args[2].toLowerCase(Locale.ENGLISH).replaceAll("l", ""))) {
            return Lists.newArrayList((Object[])new String[]{levellessArg + "l"});
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (ExpCommands cmd : ExpCommands.values()) {
                list.add(cmd.name().toLowerCase(Locale.ENGLISH));
            }
            return list;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("give")) {
                String levellessArg = args[1].toLowerCase(Locale.ENGLISH).replace("l", "");
                if (NumberUtil.isInt(levellessArg)) {
                    return Lists.newArrayList((Object[])new String[]{levellessArg, args[1] + "l"});
                }
                return Collections.emptyList();
            }
            return this.getPlayers(server, sender);
        }
        if (args.length == 3 && (args[0].equalsIgnoreCase("set") || args[0].equalsIgnoreCase("give"))) {
            return this.getPlayers(server, sender);
        }
        return Collections.emptyList();
    }

    private static enum ExpCommands {
        SET,
        GIVE,
        TAKE,
        RESET,
        SHOW(false);

        private final boolean permCheck;

        private ExpCommands() {
            this.permCheck = true;
        }

        private ExpCommands(boolean perm) {
            this.permCheck = perm;
        }

        boolean hasPermission(IUser user) {
            return user == null || !this.permCheck || user.isAuthorized("essentials.exp." + this.name().toLowerCase(Locale.ENGLISH));
        }

        boolean hasOtherPermission(IUser user) {
            return user == null || user.isAuthorized("essentials.exp." + this.name().toLowerCase(Locale.ENGLISH) + ".others");
        }
    }
}

