/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.ess3.api.IUser;
import net.ess3.api.TranslatableException;
import net.essentialsx.api.v2.events.HomeModifyEvent;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.event.Event;

public class Commanddelhome
extends EssentialsCommand {
    public Commanddelhome() {
        super("delhome");
    }

    private void deleteHome(CommandSource sender, User user, String home) {
        HomeModifyEvent event = new HomeModifyEvent(sender.getUser(), (IUser)user, home, user.getHome(home), false);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().info("HomeModifyEvent canceled for /delhome execution by " + sender.getDisplayName());
            }
            return;
        }
        try {
            user.delHome(home);
            sender.sendTl("deleteHome", home);
        }
        catch (Exception e) {
            sender.sendTl("invalidHome", home);
        }
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        String name;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.ess.getUser(sender.getPlayer());
        String[] nameParts = args[0].split(":");
        String[] expandedArg = nameParts[0].length() != args[0].length() ? nameParts : args;
        if (expandedArg.length > 1 && (user == null || user.isAuthorized("essentials.delhome.others"))) {
            user = this.getPlayer(server, expandedArg, 0, true, true);
            name = expandedArg[1].toLowerCase(Locale.ENGLISH);
        } else {
            if (user == null) {
                throw new NotEnoughArgumentsException();
            }
            name = expandedArg[0].toLowerCase(Locale.ENGLISH);
        }
        switch (name) {
            case "bed": {
                throw new TranslatableException("invalidHomeName", new Object[0]);
            }
            case "*": {
                List<String> homes = user.getHomes();
                for (String home : homes) {
                    this.deleteHome(sender, user, home);
                }
                break;
            }
            default: {
                this.deleteHome(sender, user, name);
            }
        }
    }

    @Override
    protected List<String> getTabCompleteOptions(Server server, CommandSource sender, String commandLabel, String[] args) {
        IUser user = sender.getUser();
        boolean canDelOthers = sender.isAuthorized("essentials.delhome.others");
        if (args.length == 1) {
            ArrayList<String> homes;
            List<Object> list = homes = user == null ? new ArrayList() : user.getHomes();
            if (canDelOthers) {
                int sepIndex = args[0].indexOf(58);
                if (sepIndex < 0) {
                    this.getPlayers(server, sender).forEach(player -> homes.add(player + ":"));
                } else {
                    User otherUser;
                    String namePart = args[0].substring(0, sepIndex);
                    try {
                        otherUser = this.getPlayer(server, new String[]{namePart}, 0, true, true);
                    }
                    catch (Exception ex) {
                        return homes;
                    }
                    otherUser.getHomes().forEach(home -> homes.add(namePart + ":" + home));
                    homes.add(namePart + ":*");
                }
            }
            return homes;
        }
        return Collections.emptyList();
    }
}

