/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.ess3.api.TranslatableException;
import org.bukkit.Server;

public final class PlayerList {
    private PlayerList() {
    }

    public static String listUsers(IEssentials ess, List<User> users, String seperator) {
        StringBuilder groupString = new StringBuilder();
        Collections.sort(users);
        boolean needComma = false;
        for (User user : users) {
            if (needComma) {
                groupString.append(seperator);
            }
            needComma = true;
            if (user.isAfk()) {
                groupString.append(I18n.tlLiteral("listAfkTag", new Object[0]));
            }
            if (user.isHidden()) {
                groupString.append(I18n.tlLiteral("listHiddenTag", new Object[0]));
            }
            user.setDisplayNick();
            groupString.append(AdventureUtil.legacyToMini(user.getDisplayName()));
            String strippedNick = FormatUtil.stripFormat(user.getNickname());
            if (ess.getSettings().realNamesOnList() && strippedNick != null && !strippedNick.equals(user.getName())) {
                groupString.append(" ").append(I18n.tlLiteral("listRealName", user.getName()));
            }
            groupString.append("<white>");
        }
        return groupString.toString();
    }

    public static String listSummary(IEssentials ess, User user, boolean showHidden) {
        Object[] objects;
        String tlKey;
        Server server = ess.getServer();
        int playerHidden = 0;
        int hiddenCount = 0;
        for (User onlinePlayer : ess.getOnlineUsers()) {
            if (!onlinePlayer.isHidden() && (user == null || !onlinePlayer.isHiddenFrom(user.getBase()))) continue;
            ++playerHidden;
            if (!showHidden && (user == null || onlinePlayer.isHiddenFrom(user.getBase()))) continue;
            ++hiddenCount;
        }
        if (hiddenCount > 0) {
            tlKey = "listAmountHidden";
            objects = new Object[]{ess.getOnlinePlayers().size() - playerHidden, hiddenCount, server.getMaxPlayers()};
        } else {
            tlKey = "listAmount";
            objects = new Object[]{ess.getOnlinePlayers().size() - playerHidden, server.getMaxPlayers()};
        }
        return user == null ? I18n.tlLiteral(tlKey, objects) : user.playerTl(tlKey, objects);
    }

    public static Map<String, List<User>> getPlayerLists(IEssentials ess, IUser sender, boolean showHidden) {
        HashMap<String, List<User>> playerList = new HashMap<String, List<User>>();
        for (User onlineUser : ess.getOnlineUsers()) {
            if (sender == null && !showHidden && onlineUser.isHidden() || sender != null && !showHidden && onlineUser.isHiddenFrom(sender.getBase())) continue;
            String group = FormatUtil.stripFormat(FormatUtil.stripEssentialsFormat(onlineUser.getGroup().toLowerCase()));
            List list = playerList.computeIfAbsent(group, k -> new ArrayList());
            list.add(onlineUser);
        }
        return playerList;
    }

    public static List<User> getMergedList(IEssentials ess, Map<String, List<User>> playerList, String groupName) {
        Set<String> configGroups = ess.getSettings().getListGroupConfig().keySet();
        ArrayList<User> users = new ArrayList<User>();
        for (String configGroup : configGroups) {
            String[] groupValues;
            if (!configGroup.equalsIgnoreCase(groupName)) continue;
            for (String groupValue : groupValues = ess.getSettings().getListGroupConfig().get(configGroup).toString().trim().split(" ")) {
                List<User> u;
                if ((groupValue = groupValue.toLowerCase(Locale.ENGLISH)).isEmpty() || (u = playerList.get(groupValue.trim())) == null || u.isEmpty()) continue;
                playerList.remove(groupValue);
                users.addAll(u);
            }
        }
        return users;
    }

    public static String listGroupUsers(IEssentials ess, Map<String, List<User>> playerList, String groupName) throws Exception {
        List<User> users = PlayerList.getMergedList(ess, playerList, groupName);
        List<User> groupUsers = playerList.get(groupName);
        if (groupUsers != null && !groupUsers.isEmpty()) {
            users.addAll(groupUsers);
        }
        if (users.isEmpty()) {
            throw new TranslatableException("groupDoesNotExist", new Object[0]);
        }
        String displayGroupName = Character.toTitleCase(groupName.charAt(0)) + groupName.substring(1);
        return PlayerList.outputFormat(displayGroupName, PlayerList.listUsers(ess, users, ", "));
    }

    public static String outputFormat(String group, String message) {
        return I18n.tlLiteral("listGroupTag", FormatUtil.replaceFormat(group)) + message;
    }

    public static List<String> prepareGroupedList(IEssentials ess, CommandSource source, String commandLabel, Map<String, List<User>> playerList) {
        ArrayList<String> output = new ArrayList<String>();
        Set<String> configGroups = ess.getSettings().getListGroupConfig().keySet();
        ArrayList<String> asterisk = new ArrayList<String>();
        for (String oConfigGroup : configGroups) {
            List<User> outputUserList;
            String groupValue = ess.getSettings().getListGroupConfig().get(oConfigGroup).toString().trim();
            String configGroup = oConfigGroup.toLowerCase();
            if (groupValue.equals("*")) {
                asterisk.add(oConfigGroup);
                continue;
            }
            if (groupValue.equalsIgnoreCase("hidden")) {
                playerList.remove(configGroup);
                continue;
            }
            List<User> matchedList = playerList.get(configGroup);
            if (NumberUtil.isInt(groupValue) && matchedList != null && !matchedList.isEmpty()) {
                playerList.remove(configGroup);
                outputUserList = new ArrayList<User>(matchedList);
                int limit = Integer.parseInt(groupValue);
                if (matchedList.size() > limit) {
                    String tlKey = "groupNumber";
                    Object[] objects = new Object[]{matchedList.size(), commandLabel, FormatUtil.stripFormat(configGroup)};
                    output.add(PlayerList.outputFormat(oConfigGroup, source == null ? I18n.tlLiteral("groupNumber", objects) : source.tl("groupNumber", objects)));
                    continue;
                }
                output.add(PlayerList.outputFormat(oConfigGroup, PlayerList.listUsers(ess, outputUserList, ", ")));
                continue;
            }
            outputUserList = PlayerList.getMergedList(ess, playerList, configGroup);
            if (outputUserList.isEmpty()) continue;
            output.add(PlayerList.outputFormat(oConfigGroup, PlayerList.listUsers(ess, outputUserList, ", ")));
        }
        Set<String> var = playerList.keySet();
        String[] onlineGroups = var.toArray(new String[0]);
        Arrays.sort(onlineGroups, String.CASE_INSENSITIVE_ORDER);
        if (!asterisk.isEmpty()) {
            ArrayList asteriskUsers = new ArrayList();
            for (String onlineGroup : onlineGroups) {
                asteriskUsers.addAll(playerList.get(onlineGroup));
            }
            for (String key : asterisk) {
                playerList.put(key, asteriskUsers);
            }
            onlineGroups = asterisk.toArray(new String[0]);
        }
        for (String onlineGroup : onlineGroups) {
            String groupName;
            List<User> users = playerList.get(onlineGroup);
            String string = groupName = asterisk.isEmpty() ? users.get(0).getGroup() : onlineGroup;
            if (ess.getPermissionsHandler().getName().equals("ConfigPermissions")) {
                String string2 = groupName = source == null ? I18n.tlLiteral("connectedPlayers", new Object[0]) : source.tl("connectedPlayers", new Object[0]);
            }
            if (users == null || users.isEmpty()) continue;
            output.add(PlayerList.outputFormat(groupName, PlayerList.listUsers(ess, users, ", ")));
        }
        return output;
    }
}

