/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.AlternativeCommandsHandler;
import com.earth2me.essentials.Backup;
import com.earth2me.essentials.BalanceTopImpl;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.EssentialsBlockListener;
import com.earth2me.essentials.EssentialsEntityListener;
import com.earth2me.essentials.EssentialsLogger;
import com.earth2me.essentials.EssentialsPlayerListener;
import com.earth2me.essentials.EssentialsPluginListener;
import com.earth2me.essentials.EssentialsServerListener;
import com.earth2me.essentials.EssentialsTimer;
import com.earth2me.essentials.EssentialsUpgrade;
import com.earth2me.essentials.ExecuteTimer;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IConf;
import com.earth2me.essentials.IEssentialsModule;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.Jails;
import com.earth2me.essentials.Kits;
import com.earth2me.essentials.MailServiceImpl;
import com.earth2me.essentials.ProviderFactory;
import com.earth2me.essentials.RandomTeleport;
import com.earth2me.essentials.Settings;
import com.earth2me.essentials.TNTExplodeListener;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.UUIDPlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.UserMap;
import com.earth2me.essentials.Warps;
import com.earth2me.essentials.Worth;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.IEssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.commands.QuietAbortException;
import com.earth2me.essentials.economy.EconomyLayers;
import com.earth2me.essentials.economy.vault.VaultEconomyProvider;
import com.earth2me.essentials.items.AbstractItemDb;
import com.earth2me.essentials.items.CustomItemResolver;
import com.earth2me.essentials.items.FlatItemDb;
import com.earth2me.essentials.items.LegacyItemDb;
import com.earth2me.essentials.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.earth2me.essentials.metrics.MetricsWrapper;
import com.earth2me.essentials.paperlib.PaperLib;
import com.earth2me.essentials.perm.PermissionsDefaults;
import com.earth2me.essentials.perm.PermissionsHandler;
import com.earth2me.essentials.signs.SignBlockListener;
import com.earth2me.essentials.signs.SignEntityListener;
import com.earth2me.essentials.signs.SignPlayerListener;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.updatecheck.UpdateChecker;
import com.earth2me.essentials.userstorage.ModernUserMap;
import com.earth2me.essentials.utils.AdventureUtil;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.Economy;
import net.ess3.api.IEssentials;
import net.ess3.api.IItemDb;
import net.ess3.api.IJails;
import net.ess3.api.ISettings;
import net.ess3.api.TranslatableException;
import net.ess3.nms.refl.providers.ReflDataWorldInfoProvider;
import net.ess3.nms.refl.providers.ReflFormattedCommandAliasProvider;
import net.ess3.nms.refl.providers.ReflKnownCommandsProvider;
import net.ess3.nms.refl.providers.ReflOnlineModeProvider;
import net.ess3.nms.refl.providers.ReflPersistentDataProvider;
import net.ess3.nms.refl.providers.ReflServerStateProvider;
import net.ess3.nms.refl.providers.ReflSpawnEggProvider;
import net.ess3.nms.refl.providers.ReflSpawnerBlockProvider;
import net.ess3.nms.refl.providers.ReflSyncCommandsProvider;
import net.ess3.provider.InventoryViewProvider;
import net.ess3.provider.KnownCommandsProvider;
import net.ess3.provider.PlayerLocaleProvider;
import net.ess3.provider.ProviderListener;
import net.ess3.provider.ServerStateProvider;
import net.ess3.provider.providers.BaseBannerDataProvider;
import net.ess3.provider.providers.BaseInventoryViewProvider;
import net.ess3.provider.providers.BlockMetaSpawnerItemProvider;
import net.ess3.provider.providers.BukkitMaterialTagProvider;
import net.ess3.provider.providers.BukkitSpawnerBlockProvider;
import net.ess3.provider.providers.FixedHeightWorldInfoProvider;
import net.ess3.provider.providers.FlatSpawnEggProvider;
import net.ess3.provider.providers.LegacyBannerDataProvider;
import net.ess3.provider.providers.LegacyBiomeNameProvider;
import net.ess3.provider.providers.LegacyDamageEventProvider;
import net.ess3.provider.providers.LegacyInventoryViewProvider;
import net.ess3.provider.providers.LegacyItemUnbreakableProvider;
import net.ess3.provider.providers.LegacyPlayerLocaleProvider;
import net.ess3.provider.providers.LegacyPotionMetaProvider;
import net.ess3.provider.providers.LegacySpawnEggProvider;
import net.ess3.provider.providers.ModernDamageEventProvider;
import net.ess3.provider.providers.ModernDataWorldInfoProvider;
import net.ess3.provider.providers.ModernItemUnbreakableProvider;
import net.ess3.provider.providers.ModernPersistentDataProvider;
import net.ess3.provider.providers.ModernPlayerLocaleProvider;
import net.ess3.provider.providers.ModernPotionMetaProvider;
import net.ess3.provider.providers.ModernSignDataProvider;
import net.ess3.provider.providers.ModernSyncCommandsProvider;
import net.ess3.provider.providers.PaperBiomeKeyProvider;
import net.ess3.provider.providers.PaperContainerProvider;
import net.ess3.provider.providers.PaperKnownCommandsProvider;
import net.ess3.provider.providers.PaperMaterialTagProvider;
import net.ess3.provider.providers.PaperRecipeBookListener;
import net.ess3.provider.providers.PaperSerializationProvider;
import net.ess3.provider.providers.PaperServerStateProvider;
import net.ess3.provider.providers.PaperTickCountProvider;
import net.ess3.provider.providers.PrehistoricPotionMetaProvider;
import net.essentialsx.api.v2.services.BalanceTop;
import net.essentialsx.api.v2.services.mail.MailService;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;

public class Essentials
extends JavaPlugin
implements IEssentials {
    private static final Logger BUKKIT_LOGGER = Logger.getLogger("Essentials");
    private static Logger LOGGER = null;
    public static boolean TESTING = false;
    private final transient TNTExplodeListener tntListener = new TNTExplodeListener();
    private final transient Set<String> vanishedPlayers = new LinkedHashSet<String>();
    private final transient Map<String, IEssentialsCommand> commandMap = new HashMap<String, IEssentialsCommand>();
    private final transient ProviderFactory providerFactory = new ProviderFactory(this);
    private transient ISettings settings;
    private transient Jails jails;
    private transient Warps warps;
    private transient Worth worth;
    private transient List<IConf> confList;
    private transient Backup backup;
    private transient AbstractItemDb itemDb;
    private transient CustomItemResolver customItemResolver;
    private transient PermissionsHandler permissionsHandler;
    private transient AlternativeCommandsHandler alternativeCommandsHandler;
    @Deprecated
    private transient UserMap legacyUserMap;
    private transient ModernUserMap userMap;
    private transient BalanceTopImpl balanceTop;
    private transient ExecuteTimer execTimer;
    private transient MailService mail;
    private transient I18n i18n;
    private transient MetricsWrapper metrics;
    private transient EssentialsTimer timer;
    private transient ProviderListener recipeBookEventProvider;
    private transient Kits kits;
    private transient RandomTeleport randomTeleport;
    private transient UpdateChecker updateChecker;
    private transient BukkitAudiences bukkitAudience;

    @Override
    public ISettings getSettings() {
        return this.settings;
    }

    public void onLoad() {
        try {
            Class.forName("net.milkbowl.vault.economy.Economy");
            this.getServer().getServicesManager().register(net.milkbowl.vault.economy.Economy.class, (Object)new VaultEconomyProvider(this), (Plugin)this, ServicePriority.Normal);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void onEnable() {
        try {
            if (BUKKIT_LOGGER != super.getLogger()) {
                BUKKIT_LOGGER.setParent(super.getLogger());
            }
            LOGGER = EssentialsLogger.getLoggerProvider(this);
            EssentialsLogger.updatePluginLogger(this);
            this.execTimer = new ExecuteTimer();
            this.execTimer.start();
            EssentialsUpgrade upgrade = new EssentialsUpgrade(this);
            upgrade.upgradeLang();
            this.execTimer.mark("AdventureUpgrade");
            this.i18n = new I18n(this);
            this.i18n.onEnable();
            this.execTimer.mark("I18n1");
            Console.setInstance(this);
            switch (VersionUtil.getServerSupportStatus()) {
                case NMS_CLEANROOM: {
                    this.getLogger().severe(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupportedCleanroom", new Object[0])));
                    break;
                }
                case DANGEROUS_FORK: {
                    this.getLogger().severe(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupportedDangerous", new Object[0])));
                    break;
                }
                case STUPID_PLUGIN: {
                    this.getLogger().severe(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupportedDumbPlugins", new Object[0])));
                    break;
                }
                case UNSTABLE: {
                    this.getLogger().severe(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupportedMods", new Object[0])));
                    break;
                }
                case OUTDATED: {
                    this.getLogger().severe(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupported", new Object[0])));
                    break;
                }
                case LIMITED: {
                    this.getLogger().info(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupportedLimitedApi", new Object[0])));
                }
            }
            if (VersionUtil.getSupportStatusClass() != null) {
                this.getLogger().info(AdventureUtil.miniToLegacy(I18n.tlLiteral("serverUnsupportedClass", VersionUtil.getSupportStatusClass())));
            }
            PluginManager pm = this.getServer().getPluginManager();
            for (Plugin plugin : pm.getPlugins()) {
                if (!plugin.getDescription().getName().startsWith("Essentials") || plugin.getDescription().getVersion().equals(this.getDescription().getVersion()) || plugin.getDescription().getName().equals("EssentialsAntiCheat")) continue;
                this.getLogger().warning(AdventureUtil.miniToLegacy(I18n.tlLiteral("versionMismatch", plugin.getDescription().getName())));
            }
            upgrade.beforeSettings();
            this.execTimer.mark("Upgrade");
            this.confList = new ArrayList<IConf>();
            this.settings = new Settings(this);
            this.confList.add(this.settings);
            this.execTimer.mark("Settings");
            upgrade.preModules();
            this.execTimer.mark("Upgrade2");
            this.mail = new MailServiceImpl(this);
            this.execTimer.mark("Init(Mail)");
            this.userMap = new ModernUserMap(this);
            this.legacyUserMap = new UserMap(this.userMap);
            this.execTimer.mark("Init(Usermap)");
            this.balanceTop = new BalanceTopImpl(this);
            this.execTimer.mark("Init(BalanceTop)");
            this.kits = new Kits(this);
            this.confList.add(this.kits);
            upgrade.convertKits();
            this.execTimer.mark("Kits");
            this.randomTeleport = new RandomTeleport(this);
            this.confList.add(this.randomTeleport);
            this.execTimer.mark("Init(RandomTeleport)");
            upgrade.afterSettings();
            this.execTimer.mark("Upgrade3");
            this.warps = new Warps(this.getDataFolder());
            this.confList.add(this.warps);
            this.execTimer.mark("Init(Warp)");
            this.worth = new Worth(this.getDataFolder());
            this.confList.add(this.worth);
            this.execTimer.mark("Init(Worth)");
            this.itemDb = this.getItemDbFromConfig();
            this.confList.add(this.itemDb);
            this.execTimer.mark("Init(ItemDB)");
            this.customItemResolver = new CustomItemResolver(this);
            try {
                this.itemDb.registerResolver(this, "custom_items", this.customItemResolver);
                this.confList.add(this.customItemResolver);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.customItemResolver = null;
            }
            this.execTimer.mark("Init(CustomItemResolver)");
            this.jails = new Jails(this);
            this.confList.add(this.jails);
            this.execTimer.mark("Init(Jails)");
            EconomyLayers.onEnable(this);
            this.execTimer.mark("Init(EconomyLayers)");
            this.providerFactory.registerProvider(BlockMetaSpawnerItemProvider.class);
            this.providerFactory.registerProvider(ReflSpawnerBlockProvider.class, BukkitSpawnerBlockProvider.class);
            this.providerFactory.registerProvider(LegacySpawnEggProvider.class, ReflSpawnEggProvider.class, FlatSpawnEggProvider.class);
            this.providerFactory.registerProvider(PrehistoricPotionMetaProvider.class, LegacyPotionMetaProvider.class, ModernPotionMetaProvider.class);
            this.providerFactory.registerProvider(LegacyBannerDataProvider.class, BaseBannerDataProvider.class);
            this.providerFactory.registerProvider(ReflServerStateProvider.class, PaperServerStateProvider.class);
            this.providerFactory.registerProvider(PaperContainerProvider.class);
            this.providerFactory.registerProvider(PaperSerializationProvider.class);
            this.providerFactory.registerProvider(ReflKnownCommandsProvider.class, PaperKnownCommandsProvider.class);
            this.providerFactory.registerProvider(ReflFormattedCommandAliasProvider.class);
            this.providerFactory.registerProvider(BukkitMaterialTagProvider.class, PaperMaterialTagProvider.class);
            this.providerFactory.registerProvider(ReflSyncCommandsProvider.class, ModernSyncCommandsProvider.class);
            this.providerFactory.registerProvider(ReflPersistentDataProvider.class, ModernPersistentDataProvider.class);
            this.providerFactory.registerProvider(ReflOnlineModeProvider.class);
            this.providerFactory.registerProvider(LegacyItemUnbreakableProvider.class, ModernItemUnbreakableProvider.class);
            this.providerFactory.registerProvider(FixedHeightWorldInfoProvider.class, ReflDataWorldInfoProvider.class, ModernDataWorldInfoProvider.class);
            this.providerFactory.registerProvider(ModernSignDataProvider.class);
            this.providerFactory.registerProvider(ModernPlayerLocaleProvider.class, LegacyPlayerLocaleProvider.class);
            this.providerFactory.registerProvider(ModernDamageEventProvider.class, LegacyDamageEventProvider.class);
            this.providerFactory.registerProvider(LegacyInventoryViewProvider.class, BaseInventoryViewProvider.class);
            this.providerFactory.registerProvider(LegacyBiomeNameProvider.class);
            this.providerFactory.registerProvider(PaperBiomeKeyProvider.class);
            this.providerFactory.registerProvider(PaperTickCountProvider.class);
            if (!TESTING) {
                this.providerFactory.finalizeRegistration();
            }
            if (PaperLib.isPaper()) {
                try {
                    Class.forName("com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent");
                    this.recipeBookEventProvider = new PaperRecipeBookListener(event -> {
                        if (this.getUser(((PlayerEvent)event).getPlayer()).isRecipeSee()) {
                            ((Cancellable)event).setCancelled(true);
                        }
                    });
                    if (this.getSettings().isDebug()) {
                        LOGGER.log(Level.INFO, "Registered Paper Recipe Book Event Listener");
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            this.execTimer.mark("Init(Providers)");
            this.reload();
            ((Settings)this.settings)._lateLoadItemSpawnBlacklist();
            this.backup = new Backup(this);
            this.permissionsHandler = new PermissionsHandler(this, this.settings.useBukkitPermissions());
            this.alternativeCommandsHandler = new AlternativeCommandsHandler(this);
            this.timer = new EssentialsTimer(this);
            this.scheduleSyncRepeatingTask(this.timer, 1000L, 50L);
            Economy.setEss(this);
            this.execTimer.mark("RegHandler");
            PermissionsDefaults.registerAllBackDefaults();
            PermissionsDefaults.registerAllHatDefaults();
            if (!TESTING) {
                this.updateChecker = new UpdateChecker(this);
                this.runTaskAsynchronously(() -> {
                    this.getLogger().log(Level.INFO, AdventureUtil.miniToLegacy(I18n.tlLiteral("versionFetching", new Object[0])));
                    for (Component component : this.updateChecker.getVersionMessages(false, true, new CommandSource(this, (CommandSender)Bukkit.getConsoleSender()))) {
                        this.getLogger().log(this.getSettings().isUpdateCheckEnabled() ? Level.WARNING : Level.INFO, AdventureUtil.adventureToLegacy(component));
                    }
                });
                this.metrics = new MetricsWrapper(this, 858, true);
            }
            this.execTimer.mark("Init(External)");
            String timeroutput = this.execTimer.end();
            if (this.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Essentials load " + timeroutput);
            }
        }
        catch (NumberFormatException ex) {
            this.handleCrash(ex);
        }
        catch (Error ex) {
            this.handleCrash(ex);
            throw ex;
        }
        if (!TESTING) {
            this.getBackup().setPendingShutdown(false);
        }
    }

    public static Logger getWrappedLogger() {
        if (LOGGER != null) {
            return LOGGER;
        }
        return BUKKIT_LOGGER;
    }

    public void saveConfig() {
    }

    private void registerListeners(PluginManager pm) {
        HandlerList.unregisterAll((Plugin)this);
        if (this.getSettings().isDebug()) {
            LOGGER.log(Level.INFO, "Registering Listeners");
        }
        EssentialsPluginListener pluginListener = new EssentialsPluginListener(this);
        pm.registerEvents((Listener)pluginListener, (Plugin)this);
        this.confList.add(pluginListener);
        EssentialsPlayerListener playerListener = new EssentialsPlayerListener(this);
        playerListener.registerEvents();
        EssentialsBlockListener blockListener = new EssentialsBlockListener(this);
        pm.registerEvents((Listener)blockListener, (Plugin)this);
        SignBlockListener signBlockListener = new SignBlockListener(this);
        pm.registerEvents((Listener)signBlockListener, (Plugin)this);
        SignPlayerListener signPlayerListener = new SignPlayerListener(this);
        pm.registerEvents((Listener)signPlayerListener, (Plugin)this);
        SignEntityListener signEntityListener = new SignEntityListener(this);
        pm.registerEvents((Listener)signEntityListener, (Plugin)this);
        EssentialsEntityListener entityListener = new EssentialsEntityListener(this);
        pm.registerEvents((Listener)entityListener, (Plugin)this);
        EssentialsWorldListener worldListener = new EssentialsWorldListener(this);
        pm.registerEvents((Listener)worldListener, (Plugin)this);
        EssentialsServerListener serverListener = new EssentialsServerListener(this);
        pm.registerEvents((Listener)serverListener, (Plugin)this);
        pm.registerEvents((Listener)this.tntListener, (Plugin)this);
        if (this.recipeBookEventProvider != null) {
            pm.registerEvents((Listener)this.recipeBookEventProvider, (Plugin)this);
        }
        this.jails.resetListener();
    }

    @Override
    public ProviderFactory getProviders() {
        return this.providerFactory;
    }

    public void onDisable() {
        boolean stopping;
        if (this.bukkitAudience != null) {
            this.bukkitAudience.close();
        }
        boolean bl = stopping = TESTING || ((ServerStateProvider)this.provider(ServerStateProvider.class)).isStopping();
        if (!stopping) {
            LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("serverReloading", new Object[0])));
        }
        if (!TESTING) {
            this.getBackup().setPendingShutdown(true);
        }
        for (User user : this.getOnlineUsers()) {
            if (user.isVanished()) {
                user.setVanished(false);
                user.sendTl("unvanishedReload", new Object[0]);
            }
            if (stopping) {
                user.setLogoutLocation();
                if (!user.isHidden()) {
                    user.setLastLogout(System.currentTimeMillis());
                }
                user.cleanup();
                continue;
            }
            user.stopTransaction();
        }
        this.cleanupOpenInventories();
        if (!TESTING && this.getBackup().getTaskLock() != null && !this.getBackup().getTaskLock().isDone()) {
            LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("backupInProgress", new Object[0])));
            this.getBackup().getTaskLock().join();
        }
        if (this.i18n != null) {
            this.i18n.onDisable();
        }
        if (this.backup != null) {
            this.backup.stopTask();
        }
        if (!TESTING) {
            this.getPermissionsHandler().unregisterContexts();
        }
        Economy.setEss(null);
        AdventureUtil.setEss(null);
        Trade.closeLog();
        this.getUsers().shutdown();
        HandlerList.unregisterAll((Plugin)this);
    }

    @Override
    public void reload() {
        Trade.closeLog();
        if (this.bukkitAudience != null) {
            this.bukkitAudience.close();
            this.bukkitAudience = null;
        }
        for (IConf iConf : this.confList) {
            iConf.reloadConfig();
            this.execTimer.mark("Reload(" + iConf.getClass().getSimpleName() + ")");
        }
        this.i18n.updateLocale(this.settings.getLocale());
        for (String commandName : this.getDescription().getCommands().keySet()) {
            PluginCommand command = this.getCommand(commandName);
            if (command == null) continue;
            command.setDescription(AdventureUtil.miniToLegacy(I18n.tlLiteral(commandName + "CommandDescription", new Object[0])));
            command.setUsage(AdventureUtil.miniToLegacy(I18n.tlLiteral(commandName + "CommandUsage", new Object[0])));
        }
        PluginManager pm = this.getServer().getPluginManager();
        this.registerListeners(pm);
        AdventureUtil.setEss(this);
        this.bukkitAudience = BukkitAudiences.create(this);
    }

    private IEssentialsCommand loadCommand(String path, String name, IEssentialsModule module, ClassLoader classLoader) throws Exception {
        if (this.commandMap.containsKey(name)) {
            return this.commandMap.get(name);
        }
        IEssentialsCommand cmd = (IEssentialsCommand)classLoader.loadClass(path + name).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        cmd.setEssentials(this);
        cmd.setEssentialsModule(module);
        this.commandMap.put(name, cmd);
        return cmd;
    }

    @Override
    public Map<String, IEssentialsCommand> getCommandMap() {
        return this.commandMap;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String commandLabel, String[] args) {
        return this.onTabCompleteEssentials(sender, command, commandLabel, args, Essentials.class.getClassLoader(), "com.earth2me.essentials.commands.Command", "essentials.", null);
    }

    @Override
    public List<String> onTabCompleteEssentials(CommandSender cSender, Command command, String commandLabel, String[] args, ClassLoader classLoader, String commandPath, String permissionPrefix, IEssentialsModule module) {
        Command pc;
        if (!this.getSettings().isCommandOverridden(command.getName()) && (!commandLabel.startsWith("e") || commandLabel.equalsIgnoreCase(command.getName())) && (pc = this.alternativeCommandsHandler.getAlternative(commandLabel)) instanceof PluginCommand) {
            try {
                TabCompleter completer = ((PluginCommand)pc).getTabCompleter();
                if (completer != null) {
                    return completer.onTabComplete(cSender, command, commandLabel, args);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        try {
            IEssentialsCommand cmd;
            User user = null;
            if (cSender instanceof Player) {
                user = this.getUser((Player)cSender);
            }
            CommandSource sender = new CommandSource(this, cSender);
            if (this.getSettings().isCommandDisabled(commandLabel)) {
                Command newCmd = ((KnownCommandsProvider)this.provider(KnownCommandsProvider.class)).getKnownCommands().get(commandLabel);
                if (!(newCmd == null || newCmd instanceof PluginIdentifiableCommand && ((PluginIdentifiableCommand)newCmd).getPlugin() == this)) {
                    return newCmd.tabComplete(cSender, commandLabel, args);
                }
                return Collections.emptyList();
            }
            try {
                cmd = this.loadCommand(commandPath, command.getName(), module, classLoader);
            }
            catch (Exception ex) {
                sender.sendTl("commandNotLoaded", commandLabel);
                LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("commandNotLoaded", commandLabel)), ex);
                return Collections.emptyList();
            }
            if (user != null && !user.isAuthorized(cmd, permissionPrefix)) {
                return Collections.emptyList();
            }
            if (user != null && user.isJailed() && !user.isAuthorized(cmd, "essentials.jail.allow.")) {
                return Collections.emptyList();
            }
            try {
                if (user == null) {
                    return cmd.tabComplete(this.getServer(), sender, commandLabel, command, args);
                }
                return cmd.tabComplete(this.getServer(), user, commandLabel, command, args);
            }
            catch (Exception ex) {
                this.showError(sender, ex, commandLabel);
                LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("commandFailed", commandLabel)), ex);
                return Collections.emptyList();
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("commandFailed", commandLabel)), ex);
            return Collections.emptyList();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        this.metrics.markCommand(command.getName(), true);
        return this.onCommandEssentials(sender, command, commandLabel, args, Essentials.class.getClassLoader(), "com.earth2me.essentials.commands.Command", "essentials.", null);
    }

    @Override
    public boolean onCommandEssentials(CommandSender cSender, Command command, String commandLabel, String[] args, ClassLoader classLoader, String commandPath, String permissionPrefix, IEssentialsModule module) {
        if (!(this.getSettings().isCommandOverridden(command.getName()) || commandLabel.startsWith("e") && !commandLabel.equalsIgnoreCase(command.getName()))) {
            Command pc;
            if (this.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Searching for alternative to: " + commandLabel);
            }
            if ((pc = this.alternativeCommandsHandler.getAlternative(commandLabel)) != null) {
                this.alternativeCommandsHandler.executed(commandLabel, pc);
                try {
                    pc.execute(cSender, commandLabel, args);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
                    if (cSender instanceof Player) {
                        PlayerLocaleProvider localeProvider = (PlayerLocaleProvider)this.provider(PlayerLocaleProvider.class);
                        this.getBukkitAudience().sender(cSender).sendMessage((Component)AdventureUtil.miniMessage().deserialize(I18n.tlLocale(I18n.getLocale(localeProvider.getLocale((Player)cSender)), "internalError", new Object[0])));
                    }
                    cSender.sendMessage(I18n.tlLiteral("internalError", new Object[0]));
                }
                return true;
            }
        }
        try {
            IEssentialsCommand cmd;
            User user = null;
            Block bSenderBlock = null;
            if (cSender instanceof Player) {
                user = this.getUser((Player)cSender);
            } else if (cSender instanceof BlockCommandSender) {
                BlockCommandSender bsender = (BlockCommandSender)cSender;
                bSenderBlock = bsender.getBlock();
            }
            if (bSenderBlock != null) {
                if (this.getSettings().logCommandBlockCommands()) {
                    LOGGER.log(Level.INFO, "CommandBlock at " + bSenderBlock.getX() + "," + bSenderBlock.getY() + "," + bSenderBlock.getZ() + " issued server command: /" + commandLabel + " " + EssentialsCommand.getFinalArg(args, 0));
                }
            } else if (user == null) {
                LOGGER.log(Level.INFO, cSender.getName() + " issued server command: /" + commandLabel + " " + EssentialsCommand.getFinalArg(args, 0));
            }
            CommandSource sender = new CommandSource(this, cSender);
            if (user != null && !this.getSettings().isCommandDisabled("mail") && !command.getName().equals("mail") && user.isAuthorized("essentials.mail")) {
                user.notifyOfMail();
            }
            if (commandLabel.equalsIgnoreCase("essversion")) {
                sender.sendMessage("This server is running Essentials " + this.getDescription().getVersion());
                return true;
            }
            if (this.getSettings().isCommandDisabled(commandLabel)) {
                Command newCmd = ((KnownCommandsProvider)this.provider(KnownCommandsProvider.class)).getKnownCommands().get(commandLabel);
                if (!(newCmd == null || newCmd instanceof PluginIdentifiableCommand && this.isEssentialsPlugin(((PluginIdentifiableCommand)newCmd).getPlugin()))) {
                    return newCmd.execute(cSender, commandLabel, args);
                }
                sender.sendTl("commandDisabled", commandLabel);
                return true;
            }
            try {
                cmd = this.loadCommand(commandPath, command.getName(), module, classLoader);
            }
            catch (Exception ex) {
                sender.sendTl("commandNotLoaded", commandLabel);
                LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("commandNotLoaded", commandLabel)), ex);
                return true;
            }
            if (user != null && !user.isAuthorized(cmd, permissionPrefix)) {
                LOGGER.log(Level.INFO, AdventureUtil.miniToLegacy(I18n.tlLiteral("deniedAccessCommand", user.getName())));
                user.sendTl("noAccessCommand", new Object[0]);
                return true;
            }
            if (user != null && user.isJailed() && !user.isAuthorized(cmd, "essentials.jail.allow.")) {
                if (user.getJailTimeout() > 0L) {
                    user.sendTl("playerJailedFor", user.getName(), user.getFormattedJailTime());
                } else {
                    user.sendTl("jailMessage", new Object[0]);
                }
                return true;
            }
            try {
                if (user == null) {
                    cmd.run(this.getServer(), sender, commandLabel, command, args);
                } else {
                    cmd.run(this.getServer(), user, commandLabel, command, args);
                }
                return true;
            }
            catch (NoChargeException | QuietAbortException ex) {
                return true;
            }
            catch (NotEnoughArgumentsException ex) {
                if (this.getSettings().isVerboseCommandUsages() && !cmd.getUsageStrings().isEmpty()) {
                    sender.sendTl("commandHelpLine1", commandLabel);
                    String description = command.getDescription();
                    try {
                        description = sender.tl(command.getName() + "CommandDescription", new Object[0]);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                    sender.sendTl("commandHelpLine2", description);
                    sender.sendTl("commandHelpLine3", new Object[0]);
                    for (Map.Entry<String, String> usage : cmd.getUsageStrings().entrySet()) {
                        sender.sendTl("commandHelpLineUsage", AdventureUtil.parsed(usage.getKey().replace("<command>", commandLabel)), AdventureUtil.parsed(usage.getValue()));
                    }
                } else {
                    sender.sendMessage(command.getDescription());
                    sender.sendMessage(command.getUsage().replace("<command>", commandLabel));
                }
                if (!ex.getMessage().isEmpty()) {
                    sender.sendComponent((Component)AdventureUtil.miniMessage().deserialize(ex.getMessage()));
                }
                if (ex.getCause() != null && this.settings.isDebug()) {
                    ex.getCause().printStackTrace();
                }
                return true;
            }
            catch (Exception ex) {
                this.showError(sender, ex, commandLabel);
                if (this.settings.isDebug()) {
                    ex.printStackTrace();
                }
                return true;
            }
        }
        catch (Throwable ex) {
            LOGGER.log(Level.SEVERE, AdventureUtil.miniToLegacy(I18n.tlLiteral("commandFailed", commandLabel)), ex);
            return true;
        }
    }

    private boolean isEssentialsPlugin(Plugin plugin) {
        return plugin.getDescription().getMain().contains("com.earth2me.essentials") || plugin.getDescription().getMain().contains("net.essentialsx");
    }

    public void cleanupOpenInventories() {
        InventoryViewProvider provider = (InventoryViewProvider)this.provider(InventoryViewProvider.class);
        for (User user : this.getOnlineUsers()) {
            if (user.isRecipeSee()) {
                InventoryView view = user.getBase().getOpenInventory();
                provider.getTopInventory(view).clear();
                provider.close(view);
                user.setRecipeSee(false);
            }
            if (!user.isInvSee() && !user.isEnderSee()) continue;
            provider.close(user.getBase().getOpenInventory());
            user.setInvSee(false);
            user.setEnderSee(false);
        }
    }

    @Override
    public void showError(CommandSource sender, Throwable exception, String commandLabel) {
        if (exception instanceof TranslatableException) {
            String tlMessage = sender.tl(((TranslatableException)exception).getTlKey(), ((TranslatableException)exception).getArgs());
            sender.sendTl("errorWithMessage", AdventureUtil.parsed(tlMessage));
        } else {
            sender.sendTl("errorWithMessage", exception.getMessage());
        }
        if (this.getSettings().isDebug()) {
            LOGGER.log(Level.INFO, AdventureUtil.miniToLegacy(I18n.tlLiteral("errorCallingCommand", commandLabel)), exception);
        }
    }

    @Override
    public BukkitScheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @Override
    public IJails getJails() {
        return this.jails;
    }

    @Override
    public Warps getWarps() {
        return this.warps;
    }

    @Override
    public Worth getWorth() {
        return this.worth;
    }

    @Override
    public Backup getBackup() {
        return this.backup;
    }

    @Override
    public Kits getKits() {
        return this.kits;
    }

    @Override
    public RandomTeleport getRandomTeleport() {
        return this.randomTeleport;
    }

    @Override
    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    @Override
    @Deprecated
    public User getUser(Object base) {
        if (base instanceof Player) {
            return this.getUser((Player)base);
        }
        if (base instanceof OfflinePlayer) {
            return this.getUser(((OfflinePlayer)base).getUniqueId());
        }
        if (base instanceof UUID) {
            return this.getUser((UUID)base);
        }
        if (base instanceof String) {
            return this.getOfflineUser((String)base);
        }
        return null;
    }

    @Override
    public User getUser(String base) {
        return this.getOfflineUser(base);
    }

    @Override
    public User getUser(UUID base) {
        return this.userMap.getUser(base);
    }

    @Override
    public User getOfflineUser(String name) {
        return this.userMap.getUser(name);
    }

    @Override
    public User matchUser(Server server, User sourceUser, String searchTerm, Boolean getHidden, boolean getOffline) throws PlayerNotFoundException {
        Player exPlayer;
        try {
            exPlayer = server.getPlayer(UUID.fromString(searchTerm));
        }
        catch (IllegalArgumentException ex) {
            exPlayer = getOffline ? server.getPlayerExact(searchTerm) : server.getPlayer(searchTerm);
        }
        User user = exPlayer != null ? this.getUser(exPlayer) : this.getUser(searchTerm);
        if (user != null) {
            if (!getOffline && !user.getBase().isOnline()) {
                throw new PlayerNotFoundException();
            }
            if (getHidden.booleanValue() || this.canInteractWith(sourceUser, user)) {
                return user;
            }
            if (getOffline && user.getName().equalsIgnoreCase(searchTerm)) {
                return user;
            }
            throw new PlayerNotFoundException();
        }
        List matches = server.matchPlayer(searchTerm);
        if (matches.isEmpty()) {
            String matchText = searchTerm.toLowerCase(Locale.ENGLISH);
            for (User userMatch : this.getOnlineUsers()) {
                String displayName;
                if (!getHidden.booleanValue() && !this.canInteractWith(sourceUser, userMatch) || !(displayName = FormatUtil.stripFormat(userMatch.getDisplayName()).toLowerCase(Locale.ENGLISH)).contains(matchText)) continue;
                return userMatch;
            }
        } else {
            for (Player player : matches) {
                User userMatch = this.getUser(player);
                if (!userMatch.getDisplayName().startsWith(searchTerm) || !getHidden.booleanValue() && !this.canInteractWith(sourceUser, userMatch)) continue;
                return userMatch;
            }
            User userMatch = this.getUser((Player)matches.get(0));
            if (getHidden.booleanValue() || this.canInteractWith(sourceUser, userMatch)) {
                return userMatch;
            }
        }
        throw new PlayerNotFoundException();
    }

    @Override
    public boolean canInteractWith(CommandSource interactor, User interactee) {
        if (interactor == null) {
            return !interactee.isHidden();
        }
        if (interactor.isPlayer()) {
            return this.canInteractWith(this.getUser(interactor.getPlayer()), interactee);
        }
        return true;
    }

    @Override
    public boolean canInteractWith(User interactor, User interactee) {
        if (interactor == null) {
            return !interactee.isHidden();
        }
        if (interactor.equals(interactee)) {
            return true;
        }
        return !interactee.isHiddenFrom(interactor.getBase());
    }

    @Override
    public User getUser(Player base) {
        if (base == null) {
            return null;
        }
        if (this.userMap == null) {
            LOGGER.log(Level.WARNING, "Essentials userMap not initialized");
            return null;
        }
        User user = this.userMap.getUser(base);
        if (base.getClass() != UUIDPlayer.class || user.getBase() == null) {
            user.update(base);
        }
        return user;
    }

    private void handleCrash(Throwable exception) {
        PluginManager pm = this.getServer().getPluginManager();
        Essentials.getWrappedLogger().log(Level.SEVERE, exception.toString(), exception);
        pm.registerEvents(new Listener(){

            @EventHandler(priority=EventPriority.LOW)
            public void onPlayerJoin(PlayerJoinEvent event) {
                event.getPlayer().sendMessage("Essentials failed to load, read the log file.");
            }
        }, (Plugin)this);
        for (Player player : this.getOnlinePlayers()) {
            player.sendMessage("Essentials failed to load, read the log file.");
        }
        this.setEnabled(false);
    }

    @Override
    public World getWorld(String name) {
        int worldId;
        if (name.matches("[0-9]+") && (worldId = Integer.parseInt(name)) < this.getServer().getWorlds().size()) {
            return (World)this.getServer().getWorlds().get(worldId);
        }
        return this.getServer().getWorld(name);
    }

    @Override
    public void addReloadListener(IConf listener) {
        this.confList.add(listener);
    }

    @Override
    public int broadcastMessage(String message) {
        return this.broadcastMessage(null, null, message, true, null);
    }

    @Override
    public int broadcastMessage(IUser sender, String message) {
        return this.broadcastMessage(sender, null, message, false, null);
    }

    @Override
    public int broadcastMessage(IUser sender, String message, Predicate<IUser> shouldExclude) {
        return this.broadcastMessage(sender, null, message, false, shouldExclude);
    }

    @Override
    public int broadcastMessage(String permission, String message) {
        return this.broadcastMessage(null, permission, message, false, null);
    }

    private int broadcastMessage(IUser sender, String permission, String message, boolean keywords, Predicate<IUser> shouldExclude) {
        if (sender != null && sender.isHidden()) {
            return 0;
        }
        IText broadcast = new SimpleTextInput(message);
        Collection<Player> players = this.getOnlinePlayers();
        for (Player player : players) {
            User user = this.getUser(player);
            if ((permission != null || sender != null && user.isIgnoredPlayer(sender)) && (permission == null || !user.isAuthorized(permission)) || shouldExclude != null && shouldExclude.test(user)) continue;
            if (keywords) {
                broadcast = new KeywordReplacer(broadcast, new CommandSource(this, (CommandSender)player), this, false);
            }
            for (String messageText : broadcast.getLines()) {
                user.sendMessage(messageText);
            }
        }
        return players.size();
    }

    @Override
    public void broadcastTl(String tlKey, Object ... args) {
        this.broadcastTl(null, null, false, tlKey, args);
    }

    @Override
    public void broadcastTl(IUser sender, String tlKey, Object ... args) {
        this.broadcastTl(sender, null, false, tlKey, args);
    }

    @Override
    public void broadcastTl(IUser sender, String permission, String tlKey, Object ... args) {
        this.broadcastTl(sender, (IUser u) -> !u.isAuthorized(permission), false, tlKey, args);
    }

    @Override
    public void broadcastTl(IUser sender, Predicate<IUser> shouldExclude, String tlKey, Object ... args) {
        this.broadcastTl(sender, shouldExclude, false, tlKey, args);
    }

    @Override
    public void broadcastTl(IUser sender, Predicate<IUser> shouldExclude, boolean parseKeywords, String tlKey, Object ... args) {
        if (sender != null && sender.isHidden()) {
            return;
        }
        for (User user : this.getOnlineUsers()) {
            if (sender != null && user.isIgnoredPlayer(sender) || shouldExclude != null && shouldExclude.test(user)) continue;
            Object[] processedArgs = parseKeywords ? I18n.mutateArgs(args, s -> new KeywordReplacer(new SimpleTextInput(s.toString()), new CommandSource(this, (CommandSender)user.getBase()), this, false).getLines().get(0)) : args;
            user.sendTl(tlKey, processedArgs);
        }
    }

    @Override
    public BukkitTask runTaskAsynchronously(Runnable run) {
        return this.getScheduler().runTaskAsynchronously((Plugin)this, run);
    }

    @Override
    public BukkitTask runTaskLaterAsynchronously(Runnable run, long delay) {
        return this.getScheduler().runTaskLaterAsynchronously((Plugin)this, run, delay);
    }

    @Override
    public BukkitTask runTaskTimerAsynchronously(Runnable run, long delay, long period) {
        return this.getScheduler().runTaskTimerAsynchronously((Plugin)this, run, delay, period);
    }

    @Override
    public int scheduleSyncDelayedTask(Runnable run) {
        return this.getScheduler().scheduleSyncDelayedTask((Plugin)this, run);
    }

    @Override
    public int scheduleSyncDelayedTask(Runnable run, long delay) {
        return this.getScheduler().scheduleSyncDelayedTask((Plugin)this, run, delay);
    }

    @Override
    public int scheduleSyncRepeatingTask(Runnable run, long delay, long period) {
        return this.getScheduler().scheduleSyncRepeatingTask((Plugin)this, run, delay, period);
    }

    @Override
    public PermissionsHandler getPermissionsHandler() {
        return this.permissionsHandler;
    }

    @Override
    public AlternativeCommandsHandler getAlternativeCommandsHandler() {
        return this.alternativeCommandsHandler;
    }

    @Override
    public IItemDb getItemDb() {
        return this.itemDb;
    }

    @Override
    @Deprecated
    public UserMap getUserMap() {
        return this.legacyUserMap;
    }

    @Override
    public ModernUserMap getUsers() {
        return this.userMap;
    }

    @Override
    public BalanceTop getBalanceTop() {
        return this.balanceTop;
    }

    @Override
    public I18n getI18n() {
        return this.i18n;
    }

    @Override
    public EssentialsTimer getTimer() {
        return this.timer;
    }

    @Override
    public MailService getMail() {
        return this.mail;
    }

    @Override
    public List<String> getVanishedPlayers() {
        return Collections.unmodifiableList(new ArrayList<String>(this.vanishedPlayers));
    }

    @Override
    public Collection<String> getVanishedPlayersNew() {
        return this.vanishedPlayers;
    }

    @Override
    public Collection<Player> getOnlinePlayers() {
        return this.getServer().getOnlinePlayers();
    }

    @Override
    public Iterable<User> getOnlineUsers() {
        ArrayList<User> onlineUsers = new ArrayList<User>();
        for (Player player : this.getOnlinePlayers()) {
            onlineUsers.add(this.getUser(player));
        }
        return onlineUsers;
    }

    @Override
    public CustomItemResolver getCustomItemResolver() {
        return this.customItemResolver;
    }

    @Override
    public PluginCommand getPluginCommand(String cmd) {
        return this.getCommand(cmd);
    }

    public BukkitAudiences getBukkitAudience() {
        return this.bukkitAudience;
    }

    private AbstractItemDb getItemDbFromConfig() {
        String setting = this.settings.getItemDbType();
        if (setting.equalsIgnoreCase("json")) {
            return new FlatItemDb(this);
        }
        if (setting.equalsIgnoreCase("csv")) {
            return new LegacyItemDb(this);
        }
        VersionUtil.BukkitVersion version = VersionUtil.getServerBukkitVersion();
        if (version.isHigherThanOrEqualTo(VersionUtil.v1_13_0_R01)) {
            return new FlatItemDb(this);
        }
        return new LegacyItemDb(this);
    }

    static {
        EconomyLayers.init();
    }

    private static class EssentialsWorldListener
    implements Listener,
    Runnable {
        private final transient IEssentials ess;

        EssentialsWorldListener(IEssentials ess) {
            this.ess = ess;
        }

        @EventHandler(priority=EventPriority.LOW)
        public void onWorldLoad(WorldLoadEvent event) {
            PermissionsDefaults.registerBackDefaultFor(event.getWorld());
        }

        @Override
        public void run() {
            this.ess.reload();
        }
    }
}

