/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.libs.kyori.adventure.audience.Audience;
import com.earth2me.essentials.libs.kyori.adventure.text.Component;
import com.earth2me.essentials.messaging.IMessageRecipient;
import com.earth2me.essentials.messaging.SimpleMessageRecipient;
import com.earth2me.essentials.utils.AdventureUtil;
import java.util.UUID;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class Console
implements IMessageRecipient {
    public static final String NAME = "Console";
    public static final String DISPLAY_NAME = I18n.tlLiteral("consoleName", new Object[0]);
    private static Console instance;
    private final IEssentials ess;
    private final IMessageRecipient messageRecipient;

    private Console(IEssentials ess) {
        this.ess = ess;
        this.messageRecipient = new SimpleMessageRecipient(ess, this);
    }

    public static Console getInstance() {
        return instance;
    }

    static void setInstance(IEssentials ess) {
        instance = new Console(ess);
    }

    @Deprecated
    public static CommandSender getCommandSender(Server server) throws Exception {
        return server.getConsoleSender();
    }

    public CommandSender getCommandSender() {
        return this.ess.getServer().getConsoleSender();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public UUID getUUID() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void sendMessage(String message) {
        this.getCommandSender().sendMessage(message);
    }

    @Override
    public void sendTl(String tlKey, Object ... args) {
        String translation = I18n.tlLiteral(tlKey, args);
        if (translation.isEmpty()) {
            return;
        }
        Audience consoleAudience = ((Essentials)this.ess).getBukkitAudience().sender(this.getCommandSender());
        Object component = AdventureUtil.miniMessage().deserialize(translation);
        consoleAudience.sendMessage((Component)component);
    }

    @Override
    public String tlSender(String tlKey, Object ... args) {
        return I18n.tlLiteral(tlKey, args);
    }

    @Override
    public boolean isReachable() {
        return true;
    }

    @Override
    public IMessageRecipient.MessageResponse sendMessage(IMessageRecipient recipient, String message) {
        return this.messageRecipient.sendMessage(recipient, message);
    }

    @Override
    public IMessageRecipient.MessageResponse onReceiveMessage(IMessageRecipient sender, String message) {
        return this.messageRecipient.onReceiveMessage(sender, message);
    }

    @Override
    public IMessageRecipient getReplyRecipient() {
        return this.messageRecipient.getReplyRecipient();
    }

    @Override
    public void setReplyRecipient(IMessageRecipient recipient) {
        this.messageRecipient.setReplyRecipient(recipient);
    }

    @Override
    public boolean isHiddenFrom(Player player) {
        return false;
    }
}

