/*
 * Decompiled with CFR 0.152.
 */
package ru.akke.akit;

import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import ru.akke.akit.AmazingKit;

public class KitExecutor
implements CommandExecutor {
    private AmazingKit pl;

    public KitExecutor(AmazingKit p) {
        this.pl = p;
    }

    public String[] parseArgs(String[] as) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < as.length; ++i) {
            if (as[i].equals("")) continue;
            sb = sb.append(as[i].toLowerCase()).append(" ");
        }
        return sb.toString().trim().split(" ");
    }

    public boolean validatePermission(CommandSender s, String p) {
        if (!s.hasPermission(p)) {
            s.sendMessage(this.pl.getMsg("dontHavePerm"));
            return false;
        }
        return true;
    }

    public boolean validateConsole(CommandSender s) {
        if (s.getName().equals("CONSOLE")) {
            s.sendMessage(this.pl.getMsg("consoleCantExecuteThis"));
            return true;
        }
        return false;
    }

    public void processKitList(CommandSender cs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.pl.kitList.size(); ++i) {
            String name = this.pl.kitList.get(i);
            if (!cs.hasPermission("amazingkit.kit." + name)) continue;
            if (sb.length() != 0) {
                sb = sb.append(ChatColor.WHITE).append(", ");
            }
            sb = sb.append(ChatColor.YELLOW).append(name);
            if (!cs.hasPermission("amazingkit.manage")) continue;
            sb = sb.append(ChatColor.GREEN).append(" (").append(this.pl.kitCooldowns.get(name)).append(")");
        }
        if (sb.length() == 0) {
            cs.sendMessage(this.pl.getMsg("noKitsAvailable"));
        } else {
            cs.sendMessage(this.pl.getMsg("availableKits") + sb.toString());
        }
    }

    public void processKitCreate(CommandSender cs, String kname) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        if (this.pl.kitList.contains(kname)) {
            cs.sendMessage(this.pl.getMsg("kitAlreadyExists"));
            return;
        }
        this.pl.kitList.add(kname);
        this.pl.kitCooldowns.put(kname, 0);
        this.pl.kits.put(kname, new ArrayList());
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitCreated").replace("%kname%", kname));
    }

    public void processKitErase(CommandSender cs, String kname) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        this.pl.kitList.remove(kname);
        this.pl.kitCooldowns.remove(kname);
        this.pl.kits.remove(kname);
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitDeleted").replace("%kname%", kname));
    }

    public void processKitView(CommandSender cs, String kname) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        cs.sendMessage(this.pl.getMsg("kitDescr").replace("%kname%", kname).replace("%cooldown%", this.pl.kitCooldowns.get(kname).toString()));
        for (int i = 0; i < this.pl.kits.get(kname).size(); ++i) {
            cs.sendMessage(this.pl.getMsg("kitItemDescr").replace("%index%", Integer.toString(i + 1)).replace("%item%", this.pl.kits.get(kname).get(i).getType().toString()).replace("%count%", Integer.toString(this.pl.kits.get(kname).get(i).getAmount())));
        }
    }

    public void processKitClear(CommandSender cs, String kname) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        this.pl.kits.get(kname).clear();
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitCleared").replace("%kname%", kname));
    }

    public void processKitPushItem(CommandSender cs, String kname) {
        if (!this.validatePermission(cs, "amazingkit.manage") || this.validateConsole(cs)) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        Player p = (Player)cs;
        if (p.getItemInHand() == null || p.getItemInHand().getTypeId() == 0) {
            cs.sendMessage(this.pl.getMsg("noItemInHand"));
            return;
        }
        ItemStack is = p.getItemInHand().clone();
        this.pl.kits.get(kname).add(is);
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitItemAdded").replace("%kname%", kname).replace("%item%", is.getType().toString()));
    }

    public void processKitSetItem(CommandSender cs, String kname, String itemId) {
        if (!this.validatePermission(cs, "amazingkit.manage") || this.validateConsole(cs)) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        Player p = (Player)cs;
        if (p.getItemInHand() == null || p.getItemInHand().getTypeId() == 0) {
            cs.sendMessage(this.pl.getMsg("noItemInHand"));
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(itemId);
        }
        catch (Exception e) {
            id = -1;
        }
        if (id < 1 || id > this.pl.kits.get(kname).size()) {
            this.processKitView(cs, kname);
            cs.sendMessage(this.pl.getMsg("typeCorrectInt"));
            return;
        }
        ItemStack is = p.getItemInHand().clone();
        this.pl.kits.get(kname).set(id - 1, is);
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitItemSet").replace("%kname%", kname).replace("%item%", is.getType().toString()).replace("%id%", Integer.toString(id)));
    }

    public void processKitGetItem(CommandSender cs, String kname, String itemId) {
        if (!this.validatePermission(cs, "amazingkit.manage") || this.validateConsole(cs)) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        Player p = (Player)cs;
        int id = -1;
        try {
            id = Integer.parseInt(itemId);
        }
        catch (Exception e) {
            id = -1;
        }
        if (id < 1 || id > this.pl.kits.get(kname).size()) {
            this.processKitView(cs, kname);
            cs.sendMessage(this.pl.getMsg("typeCorrectInt"));
            return;
        }
        ItemStack is = this.pl.kits.get(kname).get(id - 1).clone();
        p.setItemInHand(is);
        cs.sendMessage(this.pl.getMsg("kitItemGet").replace("%kname%", kname).replace("%item%", is.getType().toString()).replace("%id%", Integer.toString(id)));
    }

    public void processKitDeleteItem(CommandSender cs, String kname, String itemId) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        int id = -1;
        try {
            id = Integer.parseInt(itemId);
        }
        catch (Exception e) {
            id = -1;
        }
        if (id < 1 || id > this.pl.kits.get(kname).size()) {
            this.processKitView(cs, kname);
            cs.sendMessage(this.pl.getMsg("typeCorrectInt"));
            return;
        }
        String material = this.pl.kits.get(kname).get(id - 1).getType().toString();
        this.pl.kits.get(kname).remove(id - 1);
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitItemDeleted").replace("%kname%", kname).replace("%item%", material).replace("%id%", Integer.toString(id)));
    }

    public void processKitHelp(CommandSender cs) {
        ArrayList<String> help = new ArrayList<String>();
        help.add("/kit help");
        help.add("/kit [list]");
        help.add("/kit <name>");
        if (cs.hasPermission("amazingkit.manage")) {
            help.add("/kit reload");
            help.add("/kit clearcooldown");
            help.add("/kit create <name>");
            help.add("/kit erase <name>");
            help.add("/kit clear <name>");
            help.add("/kit view <name>");
            help.add("/kit add/push/put <name> (with item in hand)");
            help.add("/kit set <name> <position> (with item in hand)");
            help.add("/kit get <name> <position>");
            help.add("/kit delete/remove/del/rem <name> <position>");
            help.add("/kit cooldown <name> <cooldown>");
        }
        cs.sendMessage(this.pl.getMsg("kitHelp"));
        for (int i = 0; i < help.size(); ++i) {
            cs.sendMessage("  " + ChatColor.YELLOW + (String)help.get(i));
        }
    }

    public void processKitReload(CommandSender cs) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        this.pl.reloadConfig();
        this.pl.conf = this.pl.getConfig();
        this.pl.loadConfiguration();
        cs.sendMessage(this.pl.getMsg("confReloaded"));
    }

    public void processKitInfo(CommandSender cs) {
        cs.sendMessage(ChatColor.GREEN + "This server is runnung " + this.pl.getDescription().getFullName());
        cs.sendMessage(ChatColor.GREEN + "http://akkez.ru/AmazingKit/");
    }

    public void processKitClearCooldown(CommandSender cs) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        this.pl.userCooldowns.clear();
        cs.sendMessage(this.pl.getMsg("cooldownsCleared"));
    }

    public void processKitSetCooldown(CommandSender cs, String kname, String value) {
        if (!this.validatePermission(cs, "amazingkit.manage")) {
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        int val = -1;
        try {
            val = Integer.parseInt(value);
        }
        catch (Exception e) {
            val = -1;
        }
        if (val < 0) {
            cs.sendMessage(this.pl.getMsg("typeCorrectInt"));
            return;
        }
        this.pl.kitCooldowns.put(kname, val);
        this.pl.saveConfiguration();
        cs.sendMessage(this.pl.getMsg("kitSetCooldown").replace("%kname%", kname).replace("%value%", Integer.toString(val)));
    }

    public void processKitDispense(CommandSender cs, String kname) {
        long diff;
        int i;
        if (this.validateConsole(cs)) {
            return;
        }
        if (!this.validatePermission(cs, "amazingkit.kit." + kname)) {
            this.processKitList(cs);
            return;
        }
        if (!this.pl.kitList.contains(kname)) {
            this.processKitList(cs);
            cs.sendMessage(this.pl.getMsg("kitNotExists"));
            return;
        }
        Player p = (Player)cs;
        PlayerInventory inv = p.getInventory();
        int freeSlots = 0;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (i = 0; i < 36; ++i) {
            if (inv.getItem(i) != null && inv.getItem(i).getTypeId() != 0) continue;
            ++freeSlots;
            slots.add(i);
        }
        if (freeSlots < this.pl.kits.get(kname).size()) {
            cs.sendMessage(this.pl.getMsg("notEgoughSlots"));
            return;
        }
        if (this.pl.userCooldowns.containsKey(kname + ";" + p.getName()) && (diff = this.pl.userCooldowns.get(kname + ";" + p.getName()) + (long)this.pl.kitCooldowns.get(kname).intValue() * 1000L - System.currentTimeMillis()) > 0L) {
            String timeform = null;
            timeform = this.pl.locale.equalsIgnoreCase("ru") ? this.pl.getRuTimeform(diff / 1000L) : this.pl.getEnTimeform(diff / 1000L);
            cs.sendMessage(this.pl.getMsg("kitCooldown").replace("%time%", timeform));
            if (!cs.hasPermission("amazingkit.manage")) {
                return;
            }
        }
        this.pl.userCooldowns.put(kname + ";" + p.getName(), System.currentTimeMillis());
        for (i = 0; i < this.pl.kits.get(kname).size(); ++i) {
            inv.setItem(((Integer)slots.get(i)).intValue(), this.pl.kits.get(kname).get(i));
        }
        this.pl.saveDatabase();
        cs.sendMessage(this.pl.getMsg("kitDispensed").replace("%kname%", kname));
    }

    public boolean onCommand(CommandSender cs, Command cmd, String wtf, String[] args0) {
        if (!this.validatePermission(cs, "amazingkit.kit")) {
            return true;
        }
        String[] args = this.parseArgs(args0);
        if ((args[0].equals("") || args[0].equals("list")) && args.length == 1) {
            this.processKitList(cs);
            return true;
        }
        if (args[0].equals("reload") && args.length == 1) {
            this.processKitReload(cs);
            return true;
        }
        if (args[0].equals("help") && args.length == 1) {
            this.processKitHelp(cs);
            return true;
        }
        if (args[0].equals("info") && args.length == 1) {
            this.processKitInfo(cs);
            return true;
        }
        if (args[0].equals("clearcooldown") && args.length == 1) {
            this.processKitClearCooldown(cs);
            return true;
        }
        if (args.length == 2 && args[0].equals("create")) {
            this.processKitCreate(cs, args[1]);
            return true;
        }
        if (args.length == 2 && args[0].equals("erase")) {
            this.processKitErase(cs, args[1]);
            return true;
        }
        if (args.length == 2 && args[0].equals("clear")) {
            this.processKitClear(cs, args[1]);
            return true;
        }
        if (args.length == 2 && args[0].equals("view")) {
            this.processKitView(cs, args[1]);
            return true;
        }
        if (args.length == 2 && (args[0].equals("put") || args[0].equals("add") || args[0].equals("push"))) {
            this.processKitPushItem(cs, args[1]);
            return true;
        }
        if (args.length == 3 && args[0].equals("set")) {
            this.processKitSetItem(cs, args[1], args[2]);
            return true;
        }
        if (args.length == 3 && args[0].equals("get")) {
            this.processKitGetItem(cs, args[1], args[2]);
            return true;
        }
        if (args.length == 3 && args[0].equals("cooldown")) {
            this.processKitSetCooldown(cs, args[1], args[2]);
            return true;
        }
        if (args.length == 3 && (args[0].equals("del") || args[0].equals("rem") || args[0].equals("delete") || args[0].equals("remove"))) {
            this.processKitDeleteItem(cs, args[1], args[2]);
            return true;
        }
        if (args.length == 1) {
            this.processKitDispense(cs, args[0]);
            return true;
        }
        cs.sendMessage(this.pl.getMsg("unknownCommandSyntax"));
        return true;
    }
}

