/*
 * Decompiled with CFR 0.152.
 */
package ru.akke.akit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mcstats.Metrics;
import ru.akke.akit.KitExecutor;
import ru.akke.akit.KitListener;

public class AmazingKit
extends JavaPlugin {
    public FileConfiguration conf;
    public Logger log;
    public HashMap<String, Long> userCooldowns = new HashMap();
    public HashMap<String, ArrayList<ItemStack>> kits = new HashMap();
    public HashMap<String, Integer> kitCooldowns = new HashMap();
    public ArrayList<String> kitList = new ArrayList();
    public String firstJoinKit;
    public String locale;

    public void onEnable() {
        this.log = this.getServer().getLogger();
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
            this._log("Created " + this.getDataFolder() + " dir");
        }
        this.conf = this.getConfig();
        this.loadConfiguration();
        this.loadDatabase();
        this.getCommand("kit").setExecutor((CommandExecutor)new KitExecutor(this));
        this.getServer().getPluginManager().registerEvents((Listener)new KitListener(this), (Plugin)this);
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (Exception e) {
            this._log("Failed to enable PluginMetrics!");
        }
        this._log("Enabled!");
    }

    public void onDisable() {
        this.saveDatabase();
        this._log("Disabled!");
    }

    public void _log(String arg) {
        this.log.info("[" + this.getDescription().getName() + "] " + arg);
    }

    public void loadDatabase() {
        File f = new File(this.getDataFolder() + "/cooldowns.dat");
        if (f.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                Object m = ois.readObject();
                this.userCooldowns = (HashMap)m;
                ois.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveDatabase() {
        Iterator<String> it = this.userCooldowns.keySet().iterator();
        while (it.hasNext()) {
            String s = it.next();
            String kitname = s.split(";")[0];
            if (!this.kitCooldowns.containsKey(kitname)) {
                it.remove();
                continue;
            }
            if (this.userCooldowns.get(s) + (long)this.kitCooldowns.get(kitname).intValue() * 1000L - System.currentTimeMillis() >= 0L) continue;
            it.remove();
        }
        File f = new File(this.getDataFolder() + "/cooldowns.dat");
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(this.userCooldowns);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadConfiguration() {
        this.conf.addDefault("messages.ru.dontHavePerm", (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432!");
        this.conf.addDefault("messages.ru.consoleCantExecuteThis", (Object)"&c\u041d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u044d\u0442\u043e \u0438\u0437 \u043a\u043e\u043d\u0441\u043e\u043b\u0438!");
        this.conf.addDefault("messages.ru.noKitsAvailable", (Object)"&e\u041d\u0435\u0442 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043d\u0430\u0431\u043e\u0440\u043e\u0432");
        this.conf.addDefault("messages.ru.availableKits", (Object)"&b\u0421\u043f\u0438\u0441\u043e\u043a \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u043d\u0430\u0431\u043e\u0440\u043e\u0432: ");
        this.conf.addDefault("messages.ru.kitAlreadyExists", (Object)"&c\u042d\u0442\u043e\u0442 \u043d\u0430\u0431\u043e\u0440 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        this.conf.addDefault("messages.ru.kitCreated", (Object)"&b\u041d\u0430\u0431\u043e\u0440 '&e%kname%&b' \u0441\u043e\u0437\u0434\u0430\u043d!");
        this.conf.addDefault("messages.ru.kitNotExists", (Object)"&c\u042d\u0442\u043e\u0433\u043e \u043d\u0430\u0431\u043e\u0440\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
        this.conf.addDefault("messages.ru.kitDeleted", (Object)"&b\u041d\u0430\u0431\u043e\u0440 '&e%kname%&b' \u0443\u0434\u0430\u043b\u0435\u043d!");
        this.conf.addDefault("messages.ru.kitDescr", (Object)"&b\u041d\u0430\u0431\u043e\u0440 '&e%kname%&b' - \u043f\u0435\u0440\u0435\u0437\u0430\u0440\u044f\u0434\u043a\u0430 &e%cooldown%&b \u0441\u0435\u043a\u0443\u043d\u0434");
        this.conf.addDefault("messages.ru.kitItemDescr", (Object)"&b  \u041f\u0440\u0435\u0434\u043c\u0435\u0442 &e#%index%&b: &a%item%&b x &a%count%");
        this.conf.addDefault("messages.ru.kitCleared", (Object)"&b\u041d\u0430\u0431\u043e\u0440 '&e%kname%&b' \u043e\u0447\u0438\u0449\u0435\u043d!");
        this.conf.addDefault("messages.ru.noItemInHand", (Object)"&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0432 \u0440\u0443\u043a\u0435!");
        this.conf.addDefault("messages.ru.typeCorrectInt", (Object)"&c\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0447\u0438\u0441\u043b\u043e!");
        this.conf.addDefault("messages.ru.kitSetCooldown", (Object)"&b\u0412 \u043d\u0430\u0431\u043e\u0440\u0435 '&e%kname%&b' \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u0437\u0430\u0440\u044f\u0434\u043a\u0430 \u0432 &e%value%&b \u0441\u0435\u043a\u0443\u043d\u0434");
        this.conf.addDefault("messages.ru.notEgoughSlots", (Object)"&c\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435!");
        this.conf.addDefault("messages.ru.kitCooldown", (Object)"&c\u042d\u0442\u043e\u0442 \u043d\u0430\u0431\u043e\u0440 \u043c\u043e\u0436\u043d\u043e \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0435\u0440\u0435\u0437 %time%");
        this.conf.addDefault("messages.ru.kitDispensed", (Object)"&b\u0412\u044b\u0434\u0430\u043d \u043d\u0430\u0431\u043e\u0440 '&e%kname%&b'");
        this.conf.addDefault("messages.ru.kitItemAdded", (Object)"&b\u0412 \u043d\u0430\u0431\u043e\u0440 '&e%kname%&b' \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442 &e%item%");
        this.conf.addDefault("messages.ru.kitItemSet", (Object)"&b\u0412 \u043d\u0430\u0431\u043e\u0440 '&e%kname%&b' \u043d\u0430 \u043c\u0435\u0441\u0442\u043e &e%id%&b \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442 &e%item%");
        this.conf.addDefault("messages.ru.kitItemGet", (Object)"&b\u0418\u0437 \u043d\u0430\u0431\u043e\u0440\u0430 '&e%kname%&b' \u0432\u044b\u0434\u0430\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442 &e%item%&b \u043f\u043e\u0434 \u043d\u043e\u043c\u0435\u0440\u043e\u043c &e%id%");
        this.conf.addDefault("messages.ru.kitItemDeleted", (Object)"&b\u0418\u0437 \u043d\u0430\u0431\u043e\u0440\u0430 '&e%kname%&b' \u0443\u0434\u0430\u043b\u0435\u043d \u043f\u0440\u0435\u0434\u043c\u0435\u0442 &e%item%&b \u043f\u043e\u0434 \u043d\u043e\u043c\u0435\u0440\u043e\u043c &e%id%");
        this.conf.addDefault("messages.ru.kitHelp", (Object)"&b\u0421\u043f\u0440\u0430\u0432\u043a\u0430: ");
        this.conf.addDefault("messages.ru.confReloaded", (Object)"&b\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.");
        this.conf.addDefault("messages.ru.cooldownsCleared", (Object)"&b\u041a\u0443\u043b\u0434\u0430\u0443\u043d \u043a\u0438\u0442\u043e\u0432 \u043e\u0431\u043d\u0443\u043b\u0435\u043d.");
        this.conf.addDefault("messages.ru.unknownCommandSyntax", (Object)"&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0441 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!");
        this.conf.addDefault("messages.en.dontHavePerm", (Object)"&cYou don't have permission!");
        this.conf.addDefault("messages.en.consoleCantExecuteThis", (Object)"&cCan't execute this from console!");
        this.conf.addDefault("messages.en.noKitsAvailable", (Object)"&eList of available kits is empty.");
        this.conf.addDefault("messages.en.availableKits", (Object)"&bList of available kits: ");
        this.conf.addDefault("messages.en.kitAlreadyExists", (Object)"&cThis kit already exists!");
        this.conf.addDefault("messages.en.kitCreated", (Object)"&bKit '&e%kname%&b' created!");
        this.conf.addDefault("messages.en.kitNotExists", (Object)"&cThis kit isn't exists!");
        this.conf.addDefault("messages.en.kitDeleted", (Object)"&bKit '&e%kname%&b' deleted!");
        this.conf.addDefault("messages.en.kitDescr", (Object)"&bKit '&e%kname%&b' - &e%cooldown%&b seconds cooldown");
        this.conf.addDefault("messages.en.kitItemDescr", (Object)"&b  Item &e#%index%&b: &a%item%&b x &a%count%");
        this.conf.addDefault("messages.en.kitCleared", (Object)"&bKit '&e%kname%&b' cleared!");
        this.conf.addDefault("messages.en.noItemInHand", (Object)"&cYou don't have any item in hand!");
        this.conf.addDefault("messages.en.typeCorrectInt", (Object)"&cType corrent integer!");
        this.conf.addDefault("messages.en.kitSetCooldown", (Object)"&bIn the kit '&e%kname%&b' is set cooldown &e%value%&b seconds");
        this.conf.addDefault("messages.en.notEgoughSlots", (Object)"&cNot enough free space in inventory!");
        this.conf.addDefault("messages.en.kitCooldown", (Object)"&cYou can get this kit after %time%");
        this.conf.addDefault("messages.en.kitDispensed", (Object)"&bIssued kit '&e%kname%&b'");
        this.conf.addDefault("messages.en.kitItemAdded", (Object)"&bAdded item &e%item%&b in kit '&e%kname%&b'");
        this.conf.addDefault("messages.en.kitItemSet", (Object)"&bAdded item &e%item%&b in kit '&e%kname%&b' on position &e%id%");
        this.conf.addDefault("messages.en.kitItemGet", (Object)"&bIssued item &e%item%&b from kit '&e%kname%&b' on position &e%id%");
        this.conf.addDefault("messages.en.kitItemDeleted", (Object)"&bRemoved item &e%item%&b in kit '&e%kname%&b' on position &e%id%");
        this.conf.addDefault("messages.en.kitHelp", (Object)"&bHelp: ");
        this.conf.addDefault("messages.en.confReloaded", (Object)"&bConfiguration file reloaded.");
        this.conf.addDefault("messages.en.cooldownsCleared", (Object)"&bUser cooldowns dropped.");
        this.conf.addDefault("messages.en.unknownCommandSyntax", (Object)"&cWrong command syntax!");
        this.conf.addDefault("kitOnFirstJoin", (Object)"none");
        this.conf.addDefault("locale", (Object)"en");
        this.conf.options().copyDefaults(true);
        this.saveConfig();
        this.reloadConfig();
        this.conf = this.getConfig();
        this.firstJoinKit = this.conf.getString("kitOnFirstJoin", "none");
        this.locale = this.conf.getString("locale", "en");
        this.kits.clear();
        this.kitCooldowns.clear();
        this.kitList.clear();
        MemorySection ms = (MemorySection)this.conf.get("kits");
        if (ms != null) {
            for (String kitname : ms.getKeys(false)) {
                kitname = kitname.toLowerCase();
                this.kitList.add(kitname);
                this.kitCooldowns.put(kitname, this.conf.getInt("kits." + kitname + ".cooldown", 0));
                this.kits.put(kitname, new ArrayList());
                int i = 1;
                while (this.conf.isItemStack("kits." + kitname + ".item" + i)) {
                    this.kits.get(kitname).add(this.conf.getItemStack("kits." + kitname + ".item" + i));
                    ++i;
                }
            }
        }
    }

    public void saveConfiguration() {
        this.conf.set("kitOnFirstJoin", (Object)this.firstJoinKit);
        this.conf.set("kits", null);
        for (int i = 0; i < this.kitList.size(); ++i) {
            String name = this.kitList.get(i);
            this.conf.set("kits." + name + ".cooldown", (Object)this.kitCooldowns.get(name));
            for (int j = 0; j < this.kits.get(name).size(); ++j) {
                this.conf.set("kits." + name + ".item" + (j + 1), (Object)this.kits.get(name).get(j));
            }
        }
        this.saveConfig();
        this.reloadConfig();
        this.conf = this.getConfig();
    }

    public String getMsg(String arg) {
        return this.conf.getString("messages." + this.locale + "." + arg, "&4Configuration key [" + arg + "] not found").replace("&", "\u00a7");
    }

    public String getRuTimeform(long arg) {
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        String res = "";
        String wordForm = "";
        if (arg >= 86400L) {
            days = arg / 86400L;
            arg -= days * 86400L;
            wordForm = "\u0434\u043d\u0435\u0439";
            if (days % 10L == 1L) {
                wordForm = "\u0434\u0435\u043d\u044c";
            }
            if (days % 10L >= 2L && days % 10L <= 4L) {
                wordForm = "\u0434\u043d\u044f";
            }
            if (days >= 5L && days <= 20L) {
                wordForm = "\u0434\u043d\u0435\u0439";
            }
            res = res + days + " " + wordForm + " ";
        }
        if (arg >= 3600L) {
            hours = arg / 3600L;
            arg -= hours * 3600L;
            wordForm = "\u0447\u0430\u0441\u043e\u0432";
            if (hours % 10L == 1L) {
                wordForm = "\u0447\u0430\u0441";
            }
            if (hours % 10L >= 2L && hours % 10L <= 4L) {
                wordForm = "\u0447\u0430\u0441\u0430";
            }
            if (hours >= 5L && hours <= 20L) {
                wordForm = "\u0447\u0430\u0441\u043e\u0432";
            }
            res = res + hours + " " + wordForm + " ";
        }
        if (arg >= 60L) {
            minutes = arg / 60L;
            wordForm = "\u043c\u0438\u043d\u0443\u0442";
            if (minutes % 10L == 1L) {
                wordForm = "\u043c\u0438\u043d\u0443\u0442\u0443";
            }
            if (minutes % 10L >= 2L && minutes % 10L <= 4L) {
                wordForm = "\u043c\u0438\u043d\u0443\u0442\u044b";
            }
            if (minutes >= 5L && minutes <= 20L) {
                wordForm = "\u043c\u0438\u043d\u0443\u0442";
            }
            res = res + minutes + " " + wordForm;
        }
        if ((res = res.trim()).equals("")) {
            res = "\u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0435\u043a\u0443\u043d\u0434";
        }
        return res;
    }

    public String getEnTimeform(long arg) {
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        String res = "";
        String wordForm = "";
        if (arg >= 86400L) {
            days = arg / 86400L;
            arg -= days * 86400L;
            wordForm = "days";
            res = res + days + " " + wordForm + " ";
        }
        if (arg >= 3600L) {
            hours = arg / 3600L;
            arg -= hours * 3600L;
            wordForm = "hours";
            res = res + hours + " " + wordForm + " ";
        }
        if (arg >= 60L) {
            minutes = arg / 60L;
            wordForm = "minutes";
            res = res + minutes + " " + wordForm;
        }
        if ((res = res.trim()).equals("")) {
            res = "a few seconds";
        }
        return res;
    }
}

